/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <sstream>

#include "CalibrationApplyParametersCommand.h"
#include "ICommandExecutor.h"

using namespace LayerManagerCalibration;
using namespace std;

ExecutionResult CalibrationApplyParametersCommand::execute(ICommandExecutor* execute)
{
    ExecutionResult result = ExecutionFailed;

    // get device configuration
    InputDeviceConfigurationMap::iterator match =
        execute->getInputDeviceConfigurations()->find(m_deviceName);
    if (match != execute->getInputDeviceConfigurations()->end())
    {
        InputDeviceConfiguration* config = match->second;
        Calibration& calibration = config->getCalibration();
        calibration.getXCoefficientOne() = m_x1;
        calibration.getXCoefficientTwo() = m_x2;
        calibration.getXCoefficientThree() = m_x3;
        calibration.getYCoefficientOne() = m_y1;
        calibration.getYCoefficientTwo() = m_y2;
        calibration.getYCoefficientThree() = m_y3;
        result = ExecutionSuccess;
    }

    return result;
}

const string CalibrationApplyParametersCommand::getString()
{
    stringstream description;
    description << "CalibrationApplyParametersCommand("
                << "deviceName=" << m_deviceName
                << ", x1=" << m_x1
                << ", x2=" << m_x2
                << ", x3=" << m_x3
                << ", y1=" << m_y1
                << ", y2=" << m_y2
                << ", y3=" << m_y3
                << ")";
    return description.str();
}
